#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>
#include <climits>
#include <unordered_map>

using namespace std;

static long long broj_pozdrava(long long k) {
    return k * (k - 1) / 2;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n; cin >> n;

    unordered_map<long long, int> pd, nd;
    unordered_map<long long, int> vp, vn;
    unordered_map<long long, int> hp, hn;

    for (int i = 0; i < n; i++) {
        long long x, y;
        cin >> x >> y;

        pd[x - y]++;
        nd[x + y]++;

        y & 1LL ? vn[x]++ : vp[x]++;
        x & 1LL ? hn[y]++ : hp[y]++;
    }

    long long ans = 0;

    auto dodaj = [&](const unordered_map<long long, int>& mapa) {
        for (auto& p : mapa) {
            ans += broj_pozdrava(p.second);
        }
    };

    dodaj(pd);
    dodaj(pd);
    dodaj(nd);
    dodaj(nd);
    dodaj(vp);
    dodaj(vn);
    dodaj(hp);
    dodaj(hn);

    cout << ans << endl;

    return 0;
}